#ifndef SHADERS_H
#define SHADERS_H
#include "../common/structs.h"
#include "../common/colors.h"
#include "../common/debug.h"

void general_shader(intersect_data *i_data, color* final_color);
void phong(intersect_data *id, color *new_color);
void refract_color(intersect_data *id, color* new_color);
void reflect_color(intersect_data *id, color* new_color);
void trans_color(intersect_data *id, color* new_color);
void distance_shader(intersect_data *i_data, color* final_color);
void object_shader(intersect_data *i_data, color* final_color);
void normal_shader(intersect_data *i_data, color* final_color);
void diffuse_lighting(intersect_data *id, color *new_color);
void black_white_filter(intersect_data *id, color *new_color);
void lens_filter(intersect_data *id, color *new_color);
void portal_filter(intersect_data *id, color *new_color);
void sin_filter(intersect_data *id, color *new_color);
void wave_shader(intersect_data *i_data, color* final_color);
void fast_shade(intersect_data *id, color *new_color);
void purple_gradiant(intersect_data *id, color *bg);

void back_black(intersect_data *id, color *bg);
void back_gradiant(intersect_data *id, color *bg);
void back_mountains(intersect_data *id, color *bg);

typedef enum{startup, pre, during, post, after} shader_type;

extern scene_data *main_scene;

//fragment shaders, buffer filters
typedef struct {
	char *name;
	char *help_text;
	//shader_type type;
	//int type;
	int (*init) (void *container, char *data);
	void* (*run) (void *data);
	void* (*cleanup) (void *data);
	void* data;
} shader_data;

shader_data* get_shader(char *name);
void setup_shaders();
char* list_shaders();

#define CHECK_STEPS(steps, max) \
	if(steps > max)\
	{\
		printd(DEBUG, "}__FUNCTION__: max recurs\n");\
		return;\
	}

#endif //SHADERS_H
